gedit development - getting started
===================================

The following explanations can be improved over time, if you see something
missing, a feedback is welcome.

Programming languages and paradigms
-----------------------------------

gedit is mostly written in C, with some plugins in Python. The
[Meson](https://mesonbuild.com/) build system is used.

The code is object-oriented and event-driven. In C, it's thanks to the use of
the GObject library (see next section). If you open some `*.c` or `*.h` files,
you may be frightened but – don't panic – it's just some C/GObject boilerplate
code, and that boilerplate can be generated by a tool. So once you've learned
GObject, you will no longer be afraid ;-)

Libraries used
--------------

As every GNOME application, gedit uses the GLib, GObject and GTK libraries. To
modify the gedit source code, you should be familiar with those libraries. See
the [GTK website](https://www.gtk.org/) and the little book
[The GLib/GTK Development Platform – A Getting Started Guide](https://gitlab.gnome.org/swilmet/glib-gtk-book).

The main "text area" in gedit is a GtkTextView widget. This widget is part of
GTK. You can learn it with the
[GtkTextView tutorial](http://www.bravegnu.org/gtktext/). The tutorial is a bit
old but the GtkTextView API has not changed a lot. (By the way, contributing to
update the tutorial would be a useful task!).

GtkTextView provides the basis, and is extended by other libraries to add more
features. See [Gedit Technology](https://gedit-technology.github.io/).

For its plugin system, gedit uses
[libpeas](https://wiki.gnome.org/Projects/Libpeas).

Plugins may have other dependencies, for example the spell-checking plugin uses
[gspell](https://gitlab.gnome.org/GNOME/gspell).

gedit architecture
------------------

The [gedit git repository](https://gitlab.gnome.org/GNOME/gedit) contains:
- The "gedit core" in the `gedit/` directory.
- The default plugins in `plugins/`.

There is also the
[gedit-plugins git repository](https://gitlab.gnome.org/GNOME/gedit-plugins)
for additional official plugins.

The gedit core provides:
- A basic text editor.
- The integration of libpeas, with an API for plugins.

There is a class diagram of gedit core in the file
[class-diagram.dia](class-diagram.dia) (but it may be outdated, see the Git log
for that file).

Build/Installation
------------------

See the file [build.md](build.md).

Suggestions
-----------

A good way to learn a lot of things is to write a new plugin (it can be a
third-party plugin at first).

Improving the API reference of the gedit core would be useful, because some
parts lack proper documentation.

A potentially easy task is to fix compilation warnings, for example when a
deprecated function is used. If you encounter a runtime warning or critical
message, it is also a good idea to fix it.

Note that gedit, although simple to use, is an old piece of software. Some parts
of the code is legacy code and would benefit from some refactoring.
