/* valaswitchsection.c generated by valac, the Vala compiler
 * generated from valaswitchsection.vala, do not modify */

/* valaswitchsection.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaSwitchSectionPrivate {
	ValaList* labels;
};

static gint ValaSwitchSection_private_offset;
static gpointer vala_switch_section_parent_class = NULL;

static void vala_switch_section_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_switch_section_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_switch_section_real_get_error_types (ValaCodeNode* base,
                                               ValaCollection* collection,
                                               ValaSourceReference* source_reference);
static gboolean vala_switch_section_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_switch_section_real_emit (ValaCodeNode* base,
                                    ValaCodeGenerator* codegen);
static void vala_switch_section_finalize (ValaCodeNode * obj);

static inline gpointer
vala_switch_section_get_instance_private (ValaSwitchSection* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSwitchSection_private_offset);
}

/**
 * Creates a new switch section.
 *
 * @param source_reference reference to source code
 * @return                 newly created switch section
 */
ValaSwitchSection*
vala_switch_section_construct (GType object_type,
                               ValaSourceReference* source_reference)
{
	ValaSwitchSection* self = NULL;
	self = (ValaSwitchSection*) vala_block_construct (object_type, source_reference);
	return self;
}

ValaSwitchSection*
vala_switch_section_new (ValaSourceReference* source_reference)
{
	return vala_switch_section_construct (VALA_TYPE_SWITCH_SECTION, source_reference);
}

/**
 * Appends the specified label to the list of switch labels.
 *
 * @param label a switch label
 */
void
vala_switch_section_add_label (ValaSwitchSection* self,
                               ValaSwitchLabel* label)
{
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->labels;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		ValaSourceReference* _tmp3_;
		ValaSourceReference* _tmp4_;
		_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) label);
		_tmp4_ = _tmp3_;
		vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp4_);
	}
	_tmp5_ = self->priv->labels;
	vala_collection_add ((ValaCollection*) _tmp5_, label);
	vala_code_node_set_parent_node ((ValaCodeNode*) label, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of switch labels.
 *
 * @return switch label list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_switch_section_get_labels (ValaSwitchSection* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->labels;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
vala_switch_section_has_default_label (ValaSwitchSection* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaSwitchLabel* _tmp7_;
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp5_ = _label_list;
			_tmp6_ = vala_list_get (_tmp5_, _label_index);
			label = (ValaSwitchLabel*) _tmp6_;
			_tmp7_ = label;
			_tmp8_ = vala_switch_label_get_expression (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ == NULL) {
				result = TRUE;
				_vala_code_node_unref0 (label);
				_vala_iterable_unref0 (_label_list);
				return result;
			}
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	result = FALSE;
	return result;
}

static void
vala_switch_section_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_switch_section (visitor, self);
}

static void
vala_switch_section_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaSwitchLabel* _tmp7_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp5_ = _label_list;
			_tmp6_ = vala_list_get (_tmp5_, _label_index);
			label = (ValaSwitchLabel*) _tmp6_;
			_tmp7_ = label;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp8_;
		gint _st_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _st_index = 0;
		_tmp8_ = vala_block_get_statements ((ValaBlock*) self);
		_st_list = _tmp8_;
		_tmp9_ = _st_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_st_size = _tmp11_;
		_st_index = -1;
		while (TRUE) {
			ValaStatement* st = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaStatement* _tmp14_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp12_ = _st_list;
			_tmp13_ = vala_list_get (_tmp12_, _st_index);
			st = (ValaStatement*) _tmp13_;
			_tmp14_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
}

static void
vala_switch_section_real_get_error_types (ValaCodeNode* base,
                                          ValaCollection* collection,
                                          ValaSourceReference* source_reference)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp0_;
		gint _stmt_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _stmt_index = 0;
		_tmp0_ = vala_block_get_statements ((ValaBlock*) self);
		_stmt_list = _tmp0_;
		_tmp1_ = _stmt_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_stmt_size = _tmp3_;
		_stmt_index = -1;
		while (TRUE) {
			ValaStatement* stmt = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaStatement* _tmp6_;
			_stmt_index = _stmt_index + 1;
			if (!(_stmt_index < _stmt_size)) {
				break;
			}
			_tmp4_ = _stmt_list;
			_tmp5_ = vala_list_get (_tmp4_, _stmt_index);
			stmt = (ValaStatement*) _tmp5_;
			_tmp6_ = stmt;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp6_, collection, source_reference);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_switch_section_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaSwitchSection * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaScope* _tmp15_;
	ValaScope* _tmp16_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp17_;
	ValaSemanticAnalyzer* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaSymbol* _tmp21_;
	ValaBlock* old_insert_block = NULL;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaBlock* _tmp24_;
	ValaBlock* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSemanticAnalyzer* _tmp28_;
	ValaSemanticAnalyzer* _tmp29_;
	ValaBlock* _tmp30_;
	ValaSemanticAnalyzer* _tmp45_;
	ValaSemanticAnalyzer* _tmp46_;
	ValaSymbol* _tmp47_;
	ValaSemanticAnalyzer* _tmp48_;
	ValaSemanticAnalyzer* _tmp49_;
	ValaBlock* _tmp50_;
	ValaBlock* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	self = (ValaSwitchSection*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp4_;
		gint _label_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _label_index = 0;
		_tmp4_ = vala_switch_section_get_labels (self);
		_label_list = _tmp4_;
		_tmp5_ = _label_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_label_size = _tmp7_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaSwitchLabel* _tmp10_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp8_ = _label_list;
			_tmp9_ = vala_list_get (_tmp8_, _label_index);
			label = (ValaSwitchLabel*) _tmp9_;
			_tmp10_ = label;
			vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	_tmp11_ = vala_code_context_get_analyzer (context);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_scope (_tmp14_);
	_tmp16_ = _tmp15_;
	vala_symbol_set_owner ((ValaSymbol*) self, _tmp16_);
	_tmp17_ = vala_code_context_get_analyzer (context);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_semantic_analyzer_get_current_symbol (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _vala_code_node_ref0 (_tmp20_);
	old_symbol = _tmp21_;
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_->insert_block;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	old_insert_block = _tmp25_;
	_tmp26_ = vala_code_context_get_analyzer (context);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	_tmp28_ = vala_code_context_get_analyzer (context);
	_tmp29_ = _tmp28_;
	_tmp30_ = _vala_code_node_ref0 ((ValaBlock*) self);
	_vala_code_node_unref0 (_tmp29_->insert_block);
	_tmp29_->insert_block = _tmp30_;
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp31_;
		gint _st_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _st_index = 0;
		_tmp31_ = vala_block_get_statements ((ValaBlock*) self);
		_st_list = _tmp31_;
		_tmp32_ = _st_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_st_size = _tmp34_;
		_st_index = -1;
		while (TRUE) {
			ValaStatement* st = NULL;
			ValaList* _tmp35_;
			gpointer _tmp36_;
			ValaStatement* _tmp37_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp35_ = _st_list;
			_tmp36_ = vala_list_get (_tmp35_, _st_index);
			st = (ValaStatement*) _tmp36_;
			_tmp37_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp37_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _local_list = NULL;
		ValaList* _tmp38_;
		gint _local_size = 0;
		ValaList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _local_index = 0;
		_tmp38_ = vala_block_get_local_variables ((ValaBlock*) self);
		_local_list = _tmp38_;
		_tmp39_ = _local_list;
		_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_local_size = _tmp41_;
		_local_index = -1;
		while (TRUE) {
			ValaLocalVariable* local = NULL;
			ValaList* _tmp42_;
			gpointer _tmp43_;
			ValaLocalVariable* _tmp44_;
			_local_index = _local_index + 1;
			if (!(_local_index < _local_size)) {
				break;
			}
			_tmp42_ = _local_list;
			_tmp43_ = vala_list_get (_tmp42_, _local_index);
			local = (ValaLocalVariable*) _tmp43_;
			_tmp44_ = local;
			vala_symbol_set_active ((ValaSymbol*) _tmp44_, FALSE);
			_vala_code_node_unref0 (local);
		}
		_vala_iterable_unref0 (_local_list);
	}
	_tmp45_ = vala_code_context_get_analyzer (context);
	_tmp46_ = _tmp45_;
	_tmp47_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp46_, _tmp47_);
	_tmp48_ = vala_code_context_get_analyzer (context);
	_tmp49_ = _tmp48_;
	_tmp50_ = old_insert_block;
	_tmp51_ = _vala_code_node_ref0 (_tmp50_);
	_vala_code_node_unref0 (_tmp49_->insert_block);
	_tmp49_->insert_block = _tmp51_;
	_tmp52_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp53_ = _tmp52_;
	result = !_tmp53_;
	_vala_code_node_unref0 (old_insert_block);
	_vala_code_node_unref0 (old_symbol);
	return result;
}

static void
vala_switch_section_real_emit (ValaCodeNode* base,
                               ValaCodeGenerator* codegen)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaSwitchLabel* _tmp7_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp5_ = _label_list;
			_tmp6_ = vala_list_get (_tmp5_, _label_index);
			label = (ValaSwitchLabel*) _tmp6_;
			_tmp7_ = label;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->emit ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), codegen);
}

static void
vala_switch_section_class_init (ValaSwitchSectionClass * klass,
                                gpointer klass_data)
{
	vala_switch_section_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_switch_section_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSwitchSection_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_switch_section_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_switch_section_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_switch_section_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_switch_section_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_switch_section_real_emit;
}

static void
vala_switch_section_instance_init (ValaSwitchSection * self,
                                   gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_switch_section_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_SWITCH_LABEL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->labels = (ValaList*) _tmp1_;
}

static void
vala_switch_section_finalize (ValaCodeNode * obj)
{
	ValaSwitchSection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SWITCH_SECTION, ValaSwitchSection);
	_vala_iterable_unref0 (self->priv->labels);
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->finalize (obj);
}

/**
 * Represents a switch section in the source code.
 */
GType
vala_switch_section_get_type (void)
{
	static volatile gsize vala_switch_section_type_id__volatile = 0;
	if (g_once_init_enter (&vala_switch_section_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchSection), 0, (GInstanceInitFunc) vala_switch_section_instance_init, NULL };
		GType vala_switch_section_type_id;
		vala_switch_section_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaSwitchSection", &g_define_type_info, 0);
		ValaSwitchSection_private_offset = g_type_add_instance_private (vala_switch_section_type_id, sizeof (ValaSwitchSectionPrivate));
		g_once_init_leave (&vala_switch_section_type_id__volatile, vala_switch_section_type_id);
	}
	return vala_switch_section_type_id__volatile;
}

