/* promise.c generated by valac 0.44.7, the Vala compiler
 * generated from promise.vala, do not modify */

/* promise.vala
 *
 * Copyright (C) 2013  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <async.h>
#include <gobject/gvaluecollector.h>

#define GEE_TYPE_PROMISE (gee_promise_get_type ())
#define GEE_PROMISE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_PROMISE, GeePromise))
#define GEE_PROMISE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_PROMISE, GeePromiseClass))
#define GEE_IS_PROMISE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_PROMISE))
#define GEE_IS_PROMISE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_PROMISE))
#define GEE_PROMISE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_PROMISE, GeePromiseClass))

typedef struct _GeePromise GeePromise;
typedef struct _GeePromiseClass GeePromiseClass;
typedef struct _GeePromisePrivate GeePromisePrivate;

#define GEE_PROMISE_TYPE_FUTURE (gee_promise_future_get_type ())
#define GEE_PROMISE_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PROMISE_TYPE_FUTURE, GeePromiseFuture))
#define GEE_PROMISE_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PROMISE_TYPE_FUTURE, GeePromiseFutureClass))
#define GEE_PROMISE_IS_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PROMISE_TYPE_FUTURE))
#define GEE_PROMISE_IS_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PROMISE_TYPE_FUTURE))
#define GEE_PROMISE_FUTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PROMISE_TYPE_FUTURE, GeePromiseFutureClass))

typedef struct _GeePromiseFuture GeePromiseFuture;
typedef struct _GeePromiseFutureClass GeePromiseFutureClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GEE_TYPE_FUTURE (gee_future_get_type ())
#define GEE_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_FUTURE, GeeFuture))
#define GEE_IS_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_FUTURE))
#define GEE_FUTURE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_FUTURE, GeeFutureIface))

typedef struct _GeeFuture GeeFuture;
typedef struct _GeeFutureIface GeeFutureIface;
typedef gpointer (*GeeFutureMapFunc) (gconstpointer value, gpointer user_data);
typedef gconstpointer (*GeeFutureLightMapFunc) (gconstpointer value, gpointer user_data);
typedef gpointer (*GeeFutureZipFunc) (gconstpointer a, gconstpointer b, gpointer user_data);
typedef GeeFuture* (*GeeFutureFlatMapFunc) (gconstpointer value, gpointer user_data);
typedef struct _GeePromiseFuturePrivate GeePromiseFuturePrivate;
typedef enum  {
	GEE_PROMISE_FUTURE_STATE_INIT,
	GEE_PROMISE_FUTURE_STATE_ABANDON,
	GEE_PROMISE_FUTURE_STATE_EXCEPTION,
	GEE_PROMISE_FUTURE_STATE_READY
} GeePromiseFutureState;

#define GEE_PROMISE_FUTURE_TYPE_STATE (gee_promise_future_state_get_type ())

#define GEE_FUTURE_TYPE_SOURCE_FUNC_ARRAY_ELEMENT (gee_future_source_func_array_element_get_type ())
typedef struct _GeeFutureSourceFuncArrayElement GeeFutureSourceFuncArrayElement;
enum  {
	GEE_PROMISE_FUTURE_0_PROPERTY,
	GEE_PROMISE_FUTURE_G_TYPE,
	GEE_PROMISE_FUTURE_G_DUP_FUNC,
	GEE_PROMISE_FUTURE_G_DESTROY_FUNC,
	GEE_PROMISE_FUTURE_READY_PROPERTY,
	GEE_PROMISE_FUTURE_EXCEPTION_PROPERTY,
	GEE_PROMISE_FUTURE_NUM_PROPERTIES
};
static GParamSpec* gee_promise_future_properties[GEE_PROMISE_FUTURE_NUM_PROPERTIES];
typedef struct _GeePromiseFutureWaitAsyncData GeePromiseFutureWaitAsyncData;
typedef struct _GeeParamSpecPromise GeeParamSpecPromise;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeePromise {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeePromisePrivate * priv;
};

struct _GeePromiseClass {
	GTypeClass parent_class;
	void (*finalize) (GeePromise *self);
};

struct _GeePromisePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeePromiseFuture* _future;
};

typedef enum  {
	GEE_FUTURE_ERROR_ABANDON_PROMISE,
	GEE_FUTURE_ERROR_EXCEPTION
} GeeFutureError;
#define GEE_FUTURE_ERROR gee_future_error_quark ()
struct _GeeFutureIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeFuture* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeFuture* self);
	GDestroyNotify (*get_g_destroy_func) (GeeFuture* self);
	gconstpointer (*wait) (GeeFuture* self, GError** error);
	gboolean (*wait_until) (GeeFuture* self, gint64 end_time, gconstpointer* value, GError** error);
	void (*wait_async) (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gconstpointer (*wait_finish) (GeeFuture* self, GAsyncResult* _res_, GError** error);
	GeeFuture* (*map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, gpointer func_target, GDestroyNotify func_target_destroy_notify);
	GeeFuture* (*light_map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, gpointer func_target);
	GeeFuture* (*zip) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, gpointer zip_func_target, GeeFuture* second);
	GeeFuture* (*flat_map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, gpointer func_target, GDestroyNotify func_target_destroy_notify);
	gconstpointer (*get_value) (GeeFuture* self);
	gboolean (*get_ready) (GeeFuture* self);
	GError* (*get_exception) (GeeFuture* self);
	GeeFuture* (*light_map_fixed) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, gpointer func_target, GDestroyNotify func_target_destroy_notify);
};

struct _GeePromiseFuture {
	GObject parent_instance;
	GeePromiseFuturePrivate * priv;
};

struct _GeePromiseFutureClass {
	GObjectClass parent_class;
};

struct _GeeFutureSourceFuncArrayElement {
	GSourceFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeePromiseFuturePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GMutex _mutex;
	GCond _set;
	GeePromiseFutureState _state;
	gpointer _value;
	GError* _exception;
	GeeFutureSourceFuncArrayElement* _when_done;
	gint _when_done_length1;
	gint __when_done_size_;
};

struct _GeePromiseFutureWaitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GeePromiseFuture* self;
	gconstpointer result;
	GeePromiseFutureState state;
	GeePromiseFutureState _tmp0_;
	GeePromiseFutureState _tmp1_;
	GeeFutureSourceFuncArrayElement* _tmp2_;
	gint _tmp2__length1;
	GeeFutureSourceFuncArrayElement _tmp3_;
	GeePromiseFutureState _tmp4_;
	GeePromiseFutureState _tmp5_;
	GeePromiseFutureState _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	gconstpointer _tmp9_;
	GError* _inner_error0_;
};

struct _GeeParamSpecPromise {
	GParamSpec parent_instance;
};

static gint GeePromise_private_offset;
static gpointer gee_promise_parent_class = NULL;
static gint GeePromiseFuture_private_offset;
static gpointer gee_promise_future_parent_class = NULL;
static GeeFutureIface * gee_promise_future_gee_future_parent_iface = NULL;

gpointer gee_promise_ref (gpointer instance);
void gee_promise_unref (gpointer instance);
GParamSpec* gee_param_spec_promise (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void gee_value_set_promise (GValue* value,
                            gpointer v_object);
void gee_value_take_promise (GValue* value,
                             gpointer v_object);
gpointer gee_value_get_promise (const GValue* value);
GType gee_promise_get_type (void) G_GNUC_CONST;
static GType gee_promise_future_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void gee_promise_future_abandon (GeePromiseFuture* self);
GeePromise* gee_promise_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func);
GeePromise* gee_promise_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func);
static GeePromiseFuture* gee_promise_future_new (GType g_type,
                                          GBoxedCopyFunc g_dup_func,
                                          GDestroyNotify g_destroy_func);
static GeePromiseFuture* gee_promise_future_construct (GType object_type,
                                                GType g_type,
                                                GBoxedCopyFunc g_dup_func,
                                                GDestroyNotify g_destroy_func);
void gee_promise_set_value (GeePromise* self,
                            gpointer value);
static void gee_promise_future_set_value (GeePromiseFuture* self,
                                   gpointer value);
void gee_promise_set_exception (GeePromise* self,
                                GError* exception);
static void gee_promise_future_set_exception (GeePromiseFuture* self,
                                       GError* exception);
GQuark gee_future_error_quark (void);
GType gee_future_get_type (void) G_GNUC_CONST;
GeeFuture* gee_promise_get_future (GeePromise* self);
static GType gee_promise_future_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_GNUC_INTERNAL GType gee_future_source_func_array_element_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_GNUC_INTERNAL GeeFutureSourceFuncArrayElement* gee_future_source_func_array_element_dup (const GeeFutureSourceFuncArrayElement* self);
G_GNUC_INTERNAL void gee_future_source_func_array_element_free (GeeFutureSourceFuncArrayElement* self);
G_GNUC_INTERNAL void gee_future_source_func_array_element_copy (const GeeFutureSourceFuncArrayElement* self,
                                                GeeFutureSourceFuncArrayElement* dest);
G_GNUC_INTERNAL void gee_future_source_func_array_element_destroy (GeeFutureSourceFuncArrayElement* self);
static void _vala_GeeFutureSourceFuncArrayElement_array_free (GeeFutureSourceFuncArrayElement * array,
                                                       gint array_length);
static gconstpointer gee_promise_future_real_wait (GeeFuture* base,
                                            GError** error);
static gboolean gee_promise_future_real_wait_until (GeeFuture* base,
                                             gint64 end_time,
                                             gconstpointer* value,
                                             GError** error);
static void gee_promise_future_real_wait_async_data_free (gpointer _data);
static void gee_promise_future_real_wait_async_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data);
static void gee_promise_future_real_wait_async (GeeFuture* base,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean gee_promise_future_real_wait_async_co (GeePromiseFutureWaitAsyncData* _data_);
void gee_future_wait_async (GeeFuture* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
gconstpointer gee_future_wait_finish (GeeFuture* self,
                                      GAsyncResult* _res_,
                                      GError** error);
static gboolean _gee_promise_future_real_wait_async_co_gsource_func (gpointer self);
G_GNUC_INTERNAL void gee_future_source_func_array_element_init (GeeFutureSourceFuncArrayElement *self,
                                                GSourceFunc func,
                                                gpointer func_target,
                                                GDestroyNotify func_target_destroy_notify);
static void _vala_array_add2 (GeeFutureSourceFuncArrayElement* * array,
                       int* length,
                       int* size,
                       const GeeFutureSourceFuncArrayElement* value);
static void gee_promise_future_wait_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void gee_promise_future_finalize (GObject * obj);
gboolean gee_future_get_ready (GeeFuture* self);
GError* gee_future_get_exception (GeeFuture* self);
static void _vala_gee_promise_future_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gee_promise_future_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void gee_promise_finalize (GeePromise * obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
gee_promise_get_instance_private (GeePromise* self)
{
	return G_STRUCT_MEMBER_P (self, GeePromise_private_offset);
}

GeePromise*
gee_promise_construct (GType object_type,
                       GType g_type,
                       GBoxedCopyFunc g_dup_func,
                       GDestroyNotify g_destroy_func)
{
	GeePromise* self = NULL;
	GeePromiseFuture* _tmp0_;
	self = (GeePromise*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = gee_promise_future_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	_g_object_unref0 (self->priv->_future);
	self->priv->_future = _tmp0_;
	return self;
}

GeePromise*
gee_promise_new (GType g_type,
                 GBoxedCopyFunc g_dup_func,
                 GDestroyNotify g_destroy_func)
{
	return gee_promise_construct (GEE_TYPE_PROMISE, g_type, g_dup_func, g_destroy_func);
}

/**
 * Sets the value of the future.
 *
 * @param value Value of future
 */
void
gee_promise_set_value (GeePromise* self,
                       gpointer value)
{
	GeePromiseFuture* _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_future;
	_tmp1_ = value;
	value = NULL;
	gee_promise_future_set_value (_tmp0_, _tmp1_);
	((value == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (value = (self->priv->g_destroy_func (value), NULL));
}

/**
 * Sets the exception.
 *
 * @param exception Exception thrown
 */
void
gee_promise_set_exception (GeePromise* self,
                           GError* exception)
{
	GeePromiseFuture* _tmp0_;
	GError* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_future;
	_tmp1_ = exception;
	exception = NULL;
	gee_promise_future_set_exception (_tmp0_, _tmp1_);
	_g_error_free0 (exception);
}

GeeFuture*
gee_promise_get_future (GeePromise* self)
{
	GeeFuture* result;
	GeePromiseFuture* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_future;
	result = (GeeFuture*) _tmp0_;
	return result;
}

static inline gpointer
gee_promise_future_get_instance_private (GeePromiseFuture* self)
{
	return G_STRUCT_MEMBER_P (self, GeePromiseFuture_private_offset);
}

static GType
gee_promise_future_state_get_type (void)
{
	static volatile gsize gee_promise_future_state_type_id__volatile = 0;
	if (g_once_init_enter (&gee_promise_future_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_PROMISE_FUTURE_STATE_INIT, "GEE_PROMISE_FUTURE_STATE_INIT", "init"}, {GEE_PROMISE_FUTURE_STATE_ABANDON, "GEE_PROMISE_FUTURE_STATE_ABANDON", "abandon"}, {GEE_PROMISE_FUTURE_STATE_EXCEPTION, "GEE_PROMISE_FUTURE_STATE_EXCEPTION", "exception"}, {GEE_PROMISE_FUTURE_STATE_READY, "GEE_PROMISE_FUTURE_STATE_READY", "ready"}, {0, NULL, NULL}};
		GType gee_promise_future_state_type_id;
		gee_promise_future_state_type_id = g_enum_register_static ("GeePromiseFutureState", values);
		g_once_init_leave (&gee_promise_future_state_type_id__volatile, gee_promise_future_state_type_id);
	}
	return gee_promise_future_state_type_id__volatile;
}

static void
_vala_GeeFutureSourceFuncArrayElement_array_free (GeeFutureSourceFuncArrayElement * array,
                                                  gint array_length)
{
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gee_future_source_func_array_element_destroy (&array[i]);
		}
	}
	g_free (array);
}

static GeePromiseFuture*
gee_promise_future_construct (GType object_type,
                              GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func)
{
	GeePromiseFuture * self = NULL;
	GeeFutureSourceFuncArrayElement* _tmp0_;
	self = (GeePromiseFuture*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = g_new0 (GeeFutureSourceFuncArrayElement, 0);
	self->priv->_when_done = (_vala_GeeFutureSourceFuncArrayElement_array_free (self->priv->_when_done, self->priv->_when_done_length1), NULL);
	self->priv->_when_done = _tmp0_;
	self->priv->_when_done_length1 = 0;
	self->priv->__when_done_size_ = self->priv->_when_done_length1;
	return self;
}

static GeePromiseFuture*
gee_promise_future_new (GType g_type,
                        GBoxedCopyFunc g_dup_func,
                        GDestroyNotify g_destroy_func)
{
	return gee_promise_future_construct (GEE_PROMISE_TYPE_FUTURE, g_type, g_dup_func, g_destroy_func);
}

static gconstpointer
gee_promise_future_real_wait (GeeFuture* base,
                              GError** error)
{
	GeePromiseFuture * self;
	gconstpointer result = NULL;
	GeePromiseFutureState state = 0;
	GeePromiseFutureState _tmp0_;
	GeePromiseFutureState _tmp1_;
	GeePromiseFutureState _tmp3_;
	GeePromiseFutureState _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (GeePromiseFuture*) base;
	g_mutex_lock (&self->priv->_mutex);
	_tmp0_ = self->priv->_state;
	state = _tmp0_;
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == GEE_PROMISE_FUTURE_STATE_INIT) {
		GeePromiseFutureState _tmp2_;
		g_cond_wait (&self->priv->_set, &self->priv->_mutex);
		_tmp2_ = self->priv->_state;
		state = _tmp2_;
	}
	_tmp3_ = state;
	_vala_assert (_tmp3_ != GEE_PROMISE_FUTURE_STATE_INIT, "state != State.INIT");
	g_mutex_unlock (&self->priv->_mutex);
	_tmp4_ = state;
	switch (_tmp4_) {
		case GEE_PROMISE_FUTURE_STATE_ABANDON:
		{
			GError* _tmp5_;
			_tmp5_ = g_error_new_literal (GEE_FUTURE_ERROR, GEE_FUTURE_ERROR_ABANDON_PROMISE, "Promise has been abandon");
			_inner_error0_ = _tmp5_;
			if (_inner_error0_->domain == GEE_FUTURE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		case GEE_PROMISE_FUTURE_STATE_EXCEPTION:
		{
			GError* _tmp6_;
			_tmp6_ = g_error_new_literal (GEE_FUTURE_ERROR, GEE_FUTURE_ERROR_EXCEPTION, "Exception has been thrown");
			_inner_error0_ = _tmp6_;
			if (_inner_error0_->domain == GEE_FUTURE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		case GEE_PROMISE_FUTURE_STATE_READY:
		{
			gconstpointer _tmp7_;
			_tmp7_ = self->priv->_value;
			result = _tmp7_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static gboolean
gee_promise_future_real_wait_until (GeeFuture* base,
                                    gint64 end_time,
                                    gconstpointer* value,
                                    GError** error)
{
	GeePromiseFuture * self;
	gconstpointer _vala_value = NULL;
	gboolean result = FALSE;
	GeePromiseFutureState state = 0;
	GeePromiseFutureState _tmp0_;
	GeePromiseFutureState _tmp1_;
	GeePromiseFutureState _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (GeePromiseFuture*) base;
	g_mutex_lock (&self->priv->_mutex);
	_tmp0_ = self->priv->_state;
	state = _tmp0_;
	_tmp1_ = state;
	if (_tmp1_ == GEE_PROMISE_FUTURE_STATE_INIT) {
		GeePromiseFutureState _tmp2_;
		g_cond_wait_until (&self->priv->_set, &self->priv->_mutex, end_time);
		_tmp2_ = self->priv->_state;
		state = _tmp2_;
	}
	g_mutex_unlock (&self->priv->_mutex);
	_tmp3_ = state;
	switch (_tmp3_) {
		case GEE_PROMISE_FUTURE_STATE_INIT:
		{
			_vala_value = NULL;
			result = FALSE;
			if (value) {
				*value = _vala_value;
			}
			return result;
		}
		case GEE_PROMISE_FUTURE_STATE_ABANDON:
		{
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (GEE_FUTURE_ERROR, GEE_FUTURE_ERROR_ABANDON_PROMISE, "Promise has been abandon");
			_inner_error0_ = _tmp4_;
			if (_inner_error0_->domain == GEE_FUTURE_ERROR) {
				gboolean _tmp5_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				return _tmp5_;
			} else {
				gboolean _tmp6_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp6_;
			}
		}
		case GEE_PROMISE_FUTURE_STATE_EXCEPTION:
		{
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (GEE_FUTURE_ERROR, GEE_FUTURE_ERROR_EXCEPTION, "Exception has been thrown");
			_inner_error0_ = _tmp7_;
			if (_inner_error0_->domain == GEE_FUTURE_ERROR) {
				gboolean _tmp8_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				return _tmp8_;
			} else {
				gboolean _tmp9_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp9_;
			}
		}
		case GEE_PROMISE_FUTURE_STATE_READY:
		{
			gconstpointer _tmp10_;
			_tmp10_ = self->priv->_value;
			_vala_value = _tmp10_;
			result = TRUE;
			if (value) {
				*value = _vala_value;
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	if (value) {
		*value = _vala_value;
	}
}

static void
gee_promise_future_real_wait_async_data_free (gpointer _data)
{
	GeePromiseFutureWaitAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GeePromiseFutureWaitAsyncData, _data_);
}

static void
gee_promise_future_real_wait_async_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data)
{
	GeePromiseFutureWaitAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gee_promise_future_real_wait_async (GeeFuture* base,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GeePromiseFuture * self;
	GeePromiseFutureWaitAsyncData* _data_;
	GeePromiseFuture* _tmp0_;
	self = (GeePromiseFuture*) base;
	_data_ = g_slice_new0 (GeePromiseFutureWaitAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, gee_promise_future_real_wait_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gee_promise_future_real_wait_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gee_promise_future_real_wait_async_co (_data_);
}

static gconstpointer
gee_promise_future_wait_finish (GeeFuture* base,
                                GAsyncResult* _res_,
                                GError** error)
{
	gconstpointer result;
	GeePromiseFutureWaitAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
_gee_promise_future_real_wait_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = gee_promise_future_real_wait_async_co (self);
	return result;
}

static void
_vala_array_add2 (GeeFutureSourceFuncArrayElement* * array,
                  int* length,
                  int* size,
                  const GeeFutureSourceFuncArrayElement* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GeeFutureSourceFuncArrayElement, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
gee_promise_future_wait_async_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	GeePromiseFutureWaitAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	gee_promise_future_real_wait_async_co (_data_);
}

static gboolean
gee_promise_future_real_wait_async_co (GeePromiseFutureWaitAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_mutex_lock (&_data_->self->priv->_mutex);
	_data_->_tmp0_ = _data_->self->priv->_state;
	_data_->state = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->state;
	if (_data_->_tmp1_ == GEE_PROMISE_FUTURE_STATE_INIT) {
		_data_->_tmp2_ = _data_->self->priv->_when_done;
		_data_->_tmp2__length1 = _data_->self->priv->_when_done_length1;
		memset (&_data_->_tmp3_, 0, sizeof (GeeFutureSourceFuncArrayElement));
		gee_future_source_func_array_element_init (&_data_->_tmp3_, _gee_promise_future_real_wait_async_co_gsource_func, _data_, NULL);
		_vala_array_add2 (&_data_->self->priv->_when_done, &_data_->self->priv->_when_done_length1, &_data_->self->priv->__when_done_size_, &_data_->_tmp3_);
		_data_->_state_ = 1;
		gee_utils_async_yield_and_unlock (&_data_->self->priv->_mutex, gee_promise_future_wait_async_ready, _data_);
		return FALSE;
		_state_1:
		gee_utils_async_yield_and_unlock_finish (_data_->_res_);
		_data_->_tmp4_ = _data_->self->priv->_state;
		_data_->state = _data_->_tmp4_;
	} else {
		g_mutex_unlock (&_data_->self->priv->_mutex);
	}
	_data_->_tmp5_ = _data_->state;
	_vala_assert (_data_->_tmp5_ != GEE_PROMISE_FUTURE_STATE_INIT, "state != State.INIT");
	_data_->_tmp6_ = _data_->state;
	switch (_data_->_tmp6_) {
		case GEE_PROMISE_FUTURE_STATE_ABANDON:
		{
			_data_->_tmp7_ = g_error_new_literal (GEE_FUTURE_ERROR, GEE_FUTURE_ERROR_ABANDON_PROMISE, "Promise has been abandon");
			_data_->_inner_error0_ = _data_->_tmp7_;
			if (_data_->_inner_error0_->domain == GEE_FUTURE_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		case GEE_PROMISE_FUTURE_STATE_EXCEPTION:
		{
			_data_->_tmp8_ = g_error_new_literal (GEE_FUTURE_ERROR, GEE_FUTURE_ERROR_EXCEPTION, "Exception has been thrown");
			_data_->_inner_error0_ = _data_->_tmp8_;
			if (_data_->_inner_error0_->domain == GEE_FUTURE_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		case GEE_PROMISE_FUTURE_STATE_READY:
		{
			_data_->_tmp9_ = _data_->self->priv->_value;
			_data_->result = _data_->_tmp9_;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!_data_->_task_complete_) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
gee_promise_future_set_value (GeePromiseFuture* self,
                              gpointer value)
{
	GeePromiseFutureState _tmp0_;
	gpointer _tmp1_;
	GeeFutureSourceFuncArrayElement* when_done = NULL;
	GeeFutureSourceFuncArrayElement* _tmp2_;
	gint _tmp2__length1;
	gint when_done_length1;
	gint _when_done_size_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->_mutex);
	_tmp0_ = self->priv->_state;
	_vala_assert (_tmp0_ == GEE_PROMISE_FUTURE_STATE_INIT, "_state == State.INIT");
	self->priv->_state = GEE_PROMISE_FUTURE_STATE_READY;
	_tmp1_ = value;
	value = NULL;
	((self->priv->_value == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->g_destroy_func (self->priv->_value), NULL));
	self->priv->_value = _tmp1_;
	g_cond_broadcast (&self->priv->_set);
	g_mutex_unlock (&self->priv->_mutex);
	_tmp2_ = self->priv->_when_done;
	_tmp2__length1 = self->priv->_when_done_length1;
	self->priv->_when_done = NULL;
	self->priv->_when_done_length1 = 0;
	when_done = _tmp2_;
	when_done_length1 = _tmp2__length1;
	_when_done_size_ = when_done_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeFutureSourceFuncArrayElement* _tmp5_;
				gint _tmp5__length1;
				GeeFutureSourceFuncArrayElement* _tmp6_;
				gint _tmp6__length1;
				GeeFutureSourceFuncArrayElement _tmp7_;
				GSourceFunc _tmp8_;
				gpointer _tmp8__target;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = when_done;
				_tmp5__length1 = when_done_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				_tmp6_ = when_done;
				_tmp6__length1 = when_done_length1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = _tmp7_.func;
				_tmp8__target = _tmp7_.func_target;
				_tmp8_ (_tmp8__target);
			}
		}
	}
	when_done = (_vala_GeeFutureSourceFuncArrayElement_array_free (when_done, when_done_length1), NULL);
	((value == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (value = (self->priv->g_destroy_func (value), NULL));
}

static void
gee_promise_future_set_exception (GeePromiseFuture* self,
                                  GError* exception)
{
	GeePromiseFutureState _tmp0_;
	GError* _tmp1_;
	GeeFutureSourceFuncArrayElement* when_done = NULL;
	GeeFutureSourceFuncArrayElement* _tmp2_;
	gint _tmp2__length1;
	gint when_done_length1;
	gint _when_done_size_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->_mutex);
	_tmp0_ = self->priv->_state;
	_vala_assert (_tmp0_ == GEE_PROMISE_FUTURE_STATE_INIT, "_state == State.INIT");
	self->priv->_state = GEE_PROMISE_FUTURE_STATE_EXCEPTION;
	_tmp1_ = exception;
	exception = NULL;
	_g_error_free0 (self->priv->_exception);
	self->priv->_exception = _tmp1_;
	g_cond_broadcast (&self->priv->_set);
	g_mutex_unlock (&self->priv->_mutex);
	_tmp2_ = self->priv->_when_done;
	_tmp2__length1 = self->priv->_when_done_length1;
	self->priv->_when_done = NULL;
	self->priv->_when_done_length1 = 0;
	when_done = _tmp2_;
	when_done_length1 = _tmp2__length1;
	_when_done_size_ = when_done_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeFutureSourceFuncArrayElement* _tmp5_;
				gint _tmp5__length1;
				GeeFutureSourceFuncArrayElement* _tmp6_;
				gint _tmp6__length1;
				GeeFutureSourceFuncArrayElement _tmp7_;
				GSourceFunc _tmp8_;
				gpointer _tmp8__target;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = when_done;
				_tmp5__length1 = when_done_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				_tmp6_ = when_done;
				_tmp6__length1 = when_done_length1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = _tmp7_.func;
				_tmp8__target = _tmp7_.func_target;
				_tmp8_ (_tmp8__target);
			}
		}
	}
	when_done = (_vala_GeeFutureSourceFuncArrayElement_array_free (when_done, when_done_length1), NULL);
	_g_error_free0 (exception);
}

static void
gee_promise_future_abandon (GeePromiseFuture* self)
{
	GeePromiseFutureState _tmp0_;
	GeePromiseFutureState _tmp1_;
	GeeFutureSourceFuncArrayElement* when_done = NULL;
	GeeFutureSourceFuncArrayElement* _tmp2_;
	gint _tmp2__length1;
	gint when_done_length1;
	gint _when_done_size_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->_mutex);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != GEE_PROMISE_FUTURE_STATE_INIT) {
		g_mutex_unlock (&self->priv->_mutex);
		return;
	}
	_tmp1_ = self->priv->_state;
	_vala_assert (_tmp1_ == GEE_PROMISE_FUTURE_STATE_INIT, "_state == State.INIT");
	self->priv->_state = GEE_PROMISE_FUTURE_STATE_ABANDON;
	g_cond_broadcast (&self->priv->_set);
	g_mutex_unlock (&self->priv->_mutex);
	_tmp2_ = self->priv->_when_done;
	_tmp2__length1 = self->priv->_when_done_length1;
	self->priv->_when_done = NULL;
	self->priv->_when_done_length1 = 0;
	when_done = _tmp2_;
	when_done_length1 = _tmp2__length1;
	_when_done_size_ = when_done_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeFutureSourceFuncArrayElement* _tmp5_;
				gint _tmp5__length1;
				GeeFutureSourceFuncArrayElement* _tmp6_;
				gint _tmp6__length1;
				GeeFutureSourceFuncArrayElement _tmp7_;
				GSourceFunc _tmp8_;
				gpointer _tmp8__target;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = when_done;
				_tmp5__length1 = when_done_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				_tmp6_ = when_done;
				_tmp6__length1 = when_done_length1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = _tmp7_.func;
				_tmp8__target = _tmp7_.func_target;
				_tmp8_ (_tmp8__target);
			}
		}
	}
	when_done = (_vala_GeeFutureSourceFuncArrayElement_array_free (when_done, when_done_length1), NULL);
}

static gboolean
gee_promise_future_real_get_ready (GeeFuture* base)
{
	gboolean result;
	GeePromiseFuture* self;
	gboolean _result_ = FALSE;
	GeePromiseFutureState _tmp0_;
	self = (GeePromiseFuture*) base;
	g_mutex_lock (&self->priv->_mutex);
	_tmp0_ = self->priv->_state;
	_result_ = _tmp0_ != GEE_PROMISE_FUTURE_STATE_INIT;
	g_mutex_unlock (&self->priv->_mutex);
	result = _result_;
	return result;
}

static GError*
gee_promise_future_real_get_exception (GeeFuture* base)
{
	GError* result;
	GeePromiseFuture* self;
	GError* _tmp0_;
	self = (GeePromiseFuture*) base;
	_tmp0_ = self->priv->_exception;
	result = _tmp0_;
	return result;
}

static void
gee_promise_future_class_init (GeePromiseFutureClass * klass,
                               gpointer klass_data)
{
	gee_promise_future_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeePromiseFuture_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_promise_future_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_promise_future_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_promise_future_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PROMISE_FUTURE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PROMISE_FUTURE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PROMISE_FUTURE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PROMISE_FUTURE_READY_PROPERTY, gee_promise_future_properties[GEE_PROMISE_FUTURE_READY_PROPERTY] = g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PROMISE_FUTURE_EXCEPTION_PROPERTY, gee_promise_future_properties[GEE_PROMISE_FUTURE_EXCEPTION_PROPERTY] = g_param_spec_pointer ("exception", "exception", "exception", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_promise_future_gee_future_get_g_type (GeePromiseFuture* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_promise_future_gee_future_get_g_dup_func (GeePromiseFuture* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_promise_future_gee_future_get_g_destroy_func (GeePromiseFuture* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_promise_future_gee_future_interface_init (GeeFutureIface * iface,
                                              gpointer iface_data)
{
	gee_promise_future_gee_future_parent_iface = g_type_interface_peek_parent (iface);
	iface->wait = (gconstpointer (*) (GeeFuture*, GError**)) gee_promise_future_real_wait;
	iface->wait_until = (gboolean (*) (GeeFuture*, gint64, gconstpointer*, GError**)) gee_promise_future_real_wait_until;
	iface->wait_async = (void (*) (GeeFuture*, GAsyncReadyCallback, gpointer)) gee_promise_future_real_wait_async;
	iface->wait_finish = (gconstpointer (*) (GeeFuture*, GAsyncResult*, GError**)) gee_promise_future_wait_finish;
	iface->get_g_type = (GType (*) (GeeFuture *)) gee_promise_future_gee_future_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeFuture *)) gee_promise_future_gee_future_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeFuture *)) gee_promise_future_gee_future_get_g_destroy_func;
	iface->get_ready = gee_promise_future_real_get_ready;
	iface->get_exception = gee_promise_future_real_get_exception;
}

static void
gee_promise_future_instance_init (GeePromiseFuture * self,
                                  gpointer klass)
{
	self->priv = gee_promise_future_get_instance_private (self);
	g_mutex_init (&self->priv->_mutex);
	g_cond_init (&self->priv->_set);
}

static void
gee_promise_future_finalize (GObject * obj)
{
	GeePromiseFuture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_PROMISE_TYPE_FUTURE, GeePromiseFuture);
	_vala_clear_GMutex (&self->priv->_mutex);
	_vala_clear_GCond (&self->priv->_set);
	((self->priv->_value == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->g_destroy_func (self->priv->_value), NULL));
	_g_error_free0 (self->priv->_exception);
	self->priv->_when_done = (_vala_GeeFutureSourceFuncArrayElement_array_free (self->priv->_when_done, self->priv->_when_done_length1), NULL);
	G_OBJECT_CLASS (gee_promise_future_parent_class)->finalize (obj);
}

static GType
gee_promise_future_get_type (void)
{
	static volatile gsize gee_promise_future_type_id__volatile = 0;
	if (g_once_init_enter (&gee_promise_future_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePromiseFutureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_promise_future_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePromiseFuture), 0, (GInstanceInitFunc) gee_promise_future_instance_init, NULL };
		static const GInterfaceInfo gee_future_info = { (GInterfaceInitFunc) gee_promise_future_gee_future_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_promise_future_type_id;
		gee_promise_future_type_id = g_type_register_static (G_TYPE_OBJECT, "GeePromiseFuture", &g_define_type_info, 0);
		g_type_add_interface_static (gee_promise_future_type_id, GEE_TYPE_FUTURE, &gee_future_info);
		GeePromiseFuture_private_offset = g_type_add_instance_private (gee_promise_future_type_id, sizeof (GeePromiseFuturePrivate));
		g_once_init_leave (&gee_promise_future_type_id__volatile, gee_promise_future_type_id);
	}
	return gee_promise_future_type_id__volatile;
}

static void
_vala_gee_promise_future_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GeePromiseFuture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_PROMISE_TYPE_FUTURE, GeePromiseFuture);
	switch (property_id) {
		case GEE_PROMISE_FUTURE_READY_PROPERTY:
		g_value_set_boolean (value, gee_future_get_ready ((GeeFuture*) self));
		break;
		case GEE_PROMISE_FUTURE_EXCEPTION_PROPERTY:
		g_value_set_pointer (value, gee_future_get_exception ((GeeFuture*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_promise_future_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GeePromiseFuture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_PROMISE_TYPE_FUTURE, GeePromiseFuture);
	switch (property_id) {
		case GEE_PROMISE_FUTURE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_PROMISE_FUTURE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_PROMISE_FUTURE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_value_promise_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gee_value_promise_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gee_promise_unref (value->data[0].v_pointer);
	}
}

static void
gee_value_promise_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_promise_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gee_value_promise_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gee_value_promise_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GeePromise * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_promise_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gee_value_promise_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	GeePromise ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_promise_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gee_param_spec_promise (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	GeeParamSpecPromise* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_TYPE_PROMISE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gee_value_get_promise (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TYPE_PROMISE), NULL);
	return value->data[0].v_pointer;
}

void
gee_value_set_promise (GValue* value,
                       gpointer v_object)
{
	GeePromise * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TYPE_PROMISE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_TYPE_PROMISE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_promise_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_promise_unref (old);
	}
}

void
gee_value_take_promise (GValue* value,
                        gpointer v_object)
{
	GeePromise * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_TYPE_PROMISE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_TYPE_PROMISE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_promise_unref (old);
	}
}

static void
gee_promise_class_init (GeePromiseClass * klass,
                        gpointer klass_data)
{
	gee_promise_parent_class = g_type_class_peek_parent (klass);
	((GeePromiseClass *) klass)->finalize = gee_promise_finalize;
	g_type_class_adjust_private_offset (klass, &GeePromise_private_offset);
}

static void
gee_promise_instance_init (GeePromise * self,
                           gpointer klass)
{
	self->priv = gee_promise_get_instance_private (self);
	self->ref_count = 1;
}

static void
gee_promise_finalize (GeePromise * obj)
{
	GeePromise * self;
	GeePromiseFuture* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_PROMISE, GeePromise);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->_future;
	gee_promise_future_abandon (_tmp0_);
	_g_object_unref0 (self->priv->_future);
}

/**
 * Promise allows to set a value with associated {@link Future}. Please note that
 * value can be stored only once.
 *
 * Typically the producer will create promise and return {@link future} while
 * keeping the promise to itself. Then when value is ready it can call {@link set_value}.
 *
 * @see Future
 * @see task
 * @since 0.11.0
 */
GType
gee_promise_get_type (void)
{
	static volatile gsize gee_promise_type_id__volatile = 0;
	if (g_once_init_enter (&gee_promise_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_value_promise_init, gee_value_promise_free_value, gee_value_promise_copy_value, gee_value_promise_peek_pointer, "p", gee_value_promise_collect_value, "p", gee_value_promise_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeePromiseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_promise_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePromise), 0, (GInstanceInitFunc) gee_promise_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_promise_type_id;
		gee_promise_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeePromise", &g_define_type_info, &g_define_type_fundamental_info, 0);
		GeePromise_private_offset = g_type_add_instance_private (gee_promise_type_id, sizeof (GeePromisePrivate));
		g_once_init_leave (&gee_promise_type_id__volatile, gee_promise_type_id);
	}
	return gee_promise_type_id__volatile;
}

gpointer
gee_promise_ref (gpointer instance)
{
	GeePromise * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gee_promise_unref (gpointer instance)
{
	GeePromise * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_PROMISE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

